/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.DpNodeDescriptions;
import ibm.nways.analysis.dpCommon.DpResourceInstance;
import ibm.nways.analysis.dpCommon.GraphInstance;
import ibm.nways.analysis.dpCommon.ViewInstance;
import ibm.nways.nhm.eui.NhmApplet;
import ibm.nways.nhm.eui.NhmView;
import ibm.nways.ras.Traces;
import java.util.Enumeration;
import java.util.ResourceBundle;
import jclass.chart.JCChart;

public class NhmChartApplet
extends NhmApplet {
    private String viewName;
    private DpResourceInstance[] instanceIds;
    private DpNodeDescriptions nodes;
    private boolean multipleInstances = false;
    private NhmView view;
    private ResourceBundle res = ResourceBundle.getBundle("ibm.nways.nhm.eui.AppletResources");
    private static final int COMMA = 44;
    private static final int EQUAL = 61;

    public void init() {
        int n;
        super.init();
        try {
            Traces.initializeTraces(this);
        }
        catch (Exception exception) {
            System.out.println("Exception occurred in init() of NhmChartApplet");
            exception.printStackTrace();
        }
        this.showStatus(this.res.getString("s_loadingParms"));
        this.viewName = this.getParameter("view_name");
        String string = this.getParameter("port_num");
        try {
            this.portNumber = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.portNumber = 2099;
        }
        String string2 = null;
        String string3 = null;
        this.createDataRetriever();
        super.getTimeParms();
        String[] stringArray = super.getHostParms();
        try {
            int n2;
            int n3;
            string = this.getParameter("instance");
            if (string != null) {
                this.instanceIds = new DpResourceInstance[1];
                this.instanceIds[0] = new DpResourceInstance();
                n3 = string.indexOf(44);
                n2 = string.indexOf(61);
                while (n2 != -1) {
                    string2 = string.substring(0, n2);
                    if (n3 == -1) {
                        string3 = string.substring(n2 + 1);
                        n2 = -1;
                    } else {
                        string3 = string.substring(n2 + 1, n3);
                        n3 = string.indexOf(44, n3 + 1);
                        n2 = string.indexOf(61, n3 + 1);
                    }
                    this.instanceIds[0].dpAddInstanceDescriptor(string2, string3);
                }
                if (this.instanceIds[0].isEmpty()) {
                    this.instanceIds[0] = null;
                }
            } else {
                this.instanceIds = new DpResourceInstance[stringArray.length];
                this.multipleInstances = true;
                n = 0;
                while (n < stringArray.length) {
                    string = this.getParameter("instance_" + String.valueOf(n + 1));
                    if (string != null && string.length() > 0) {
                        this.instanceIds[n] = new DpResourceInstance();
                        n3 = string.indexOf(44);
                        n2 = string.indexOf(61);
                        while (n2 != -1) {
                            string2 = string.substring(0, n2);
                            if (n3 == -1) {
                                string3 = string.substring(n2 + 1);
                                n2 = -1;
                            } else {
                                string3 = string.substring(n2 + 1, n3);
                                n3 = string.indexOf(44, n3 + 1);
                                n2 = string.indexOf(61, n3 + 1);
                            }
                            this.instanceIds[n].dpAddInstanceDescriptor(string2, string3);
                        }
                        if (this.instanceIds[n].isEmpty()) {
                            this.instanceIds[n] = null;
                        }
                    } else {
                        this.instanceIds[n] = null;
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            Traces.logException(exception);
        }
        try {
            this.nodes = new DpNodeDescriptions();
            n = 0;
            while (n < stringArray.length) {
                this.nodes.dpAddHostname(stringArray[n]);
                ++n;
            }
            this.view = new NhmView(this.viewName);
            this.setData();
            this.view.setSize(this.getSize().width, this.getSize().height - 100);
            this.add("Center", this.view);
            super.addButtons();
            return;
        }
        catch (Exception exception) {
            Traces.logException(exception);
            return;
        }
    }

    protected void setData() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.getSize();
        this.getSize();
        this.view.removeAll();
        try {
            this.showStatus(this.res.getString("s_retrievingData"));
            ViewInstance viewInstance = this.multipleInstances ? this.dataRetriever.getMultipleViewInstances(this.viewName, this.nodes, this.instanceIds, this.startDate, this.endDate) : this.dataRetriever.getViewInstance(this.viewName, this.nodes, this.instanceIds[0], this.startDate, this.endDate);
            if (viewInstance != null) {
                JCChart jCChart;
                GraphInstance graphInstance;
                Enumeration enumeration = null;
                enumeration = viewInstance.getGraphs().elements();
                while (enumeration.hasMoreElements()) {
                    graphInstance = (GraphInstance)enumeration.nextElement();
                    jCChart = graphInstance.getGraph(this);
                    n2 = Math.max(jCChart.getPreferredSize().width, n2);
                    n += jCChart.getPreferredSize().height;
                    ++n3;
                }
                enumeration = viewInstance.getGraphs().elements();
                while (enumeration.hasMoreElements()) {
                    graphInstance = (GraphInstance)enumeration.nextElement();
                    jCChart = graphInstance.getGraph(this);
                    this.view.addComponent(jCChart);
                }
            } else {
                Traces.logError(this, "Server returned null view instance");
            }
            this.showStatus(this.res.getString("s_retrievalComplete"));
            return;
        }
        catch (Exception exception) {
            this.showStatus(this.res.getString("s_retrievalError"));
            Traces.logError(this, "Exception caught in NhmChartApplet.init ()");
            Traces.logException(exception);
            return;
        }
    }

    public void newTimeRangeSelected() {
        this.setData();
    }

    public void stop() {
        Traces.flush();
    }
}

